package main

type ShowRymdskepp struct {
	show      bool
	stop      bool
	rymdskepp *Rymdskepp
	speed     float32
	y         float32
	onStop    func()
}

func NewShowRymdskepp(rymdskepp *Rymdskepp, speed float32, onStop func()) *ShowRymdskepp {
	sr := new(ShowRymdskepp)
	sr.show = false
	sr.stop = false
	sr.rymdskepp = rymdskepp
	sr.speed = speed
	sr.onStop = onStop
	sr.y = float32(screenHeight + rymdskepp.Height())
	return sr
}

func (sr *ShowRymdskepp) SetShow(show bool) {
	sr.show = show
}

func (sr *ShowRymdskepp) Update(deltaTime float32) {
	if sr.show && !sr.stop {
		sr.y -= sr.speed * deltaTime
		half := screenHeight / 2
		if sr.y <= float32(half) {
			sr.stop = true
			if sr.onStop != nil {
				sr.onStop()
			}
		}
		sr.rymdskepp.y = int32(sr.y)
	}
}
